/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.history;

import filenet.vw.api.VWProcess;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWWorkflowHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.history.VWParticipantHistoryRowItem;
import filenet.vw.toolkit.runtime.step.core.history.VWStepHistoryRowItem;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import java.text.DateFormat;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWHistoryTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 7;
    public static final int COL_EXPAND = 0;
    public static final int COL_STEP = 1;
    public static final int COL_OCCURRENCE = 2;
    public static final int COL_PARTICIPANT = 3;
    public static final int COL_COMPLETED = 4;
    public static final int COL_RESPONSE = 5;
    public static final int COL_COMMENTS = 6;
    private VWProcess m_vwProcess = null;
    private Vector m_rowData = null;
    private DateFormat m_dateFormat = null;

    public VWHistoryTableModel(VWProcess vwProcess) {
        this.m_vwProcess = vwProcess;
        this.m_dateFormat = DateFormat.getDateTimeInstance(2, 2);
    }

    public void setMapIds(int[] mapIds) {
        try {
            this.m_rowData = new Vector();
            if (this.m_vwProcess != null && mapIds != null) {
                for (int nIndex = 0; nIndex < mapIds.length; ++nIndex) {
                    VWWorkflowHistory vwWorkflowHistory = this.m_vwProcess.fetchFilteredWorkflowHistory(mapIds[nIndex], 1);
                    if (vwWorkflowHistory == null || !vwWorkflowHistory.hasNext()) continue;
                    while (vwWorkflowHistory.hasNext()) {
                        VWStepHistoryRowItem vwStepHistoryRowItem;
                        VWStepHistory vwStepHistory = vwWorkflowHistory.next();
                        if (vwStepHistory == null || vwStepHistory.isCompoundStep() || (vwStepHistoryRowItem = new VWStepHistoryRowItem(vwStepHistory, this.m_dateFormat)) == null || vwStepHistoryRowItem.getRowCount() <= 0) continue;
                        this.m_rowData.addElement(vwStepHistoryRowItem);
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return new String();
            }
            case 1: {
                return VWResource.s_step;
            }
            case 2: {
                return new String();
            }
            case 3: {
                return VWResource.s_participant;
            }
            case 4: {
                return VWResource.s_completed;
            }
            case 5: {
                return VWResource.s_response;
            }
            case 6: {
                return VWResource.s_comments;
            }
        }
        return null;
    }

    public int getRowCount() {
        int nCount = 0;
        if (this.m_rowData != null) {
            for (int nIndex = 0; nIndex < this.m_rowData.size(); ++nIndex) {
                VWStepHistoryRowItem rowItem = this.getRowItemAt(nIndex);
                if (rowItem == null) continue;
                if (rowItem.isExpanded()) {
                    nCount += rowItem.getRowCount();
                    continue;
                }
                ++nCount;
            }
        }
        return nCount;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        int[] nIndexes = new int[2];
        boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
        if (bFound) {
            int nStepIndex = nIndexes[0];
            int nArrayIndex = nIndexes[1];
            VWStepHistoryRowItem shRowItem = this.getRowItemAt(nStepIndex);
            VWParticipantHistoryRowItem phRowItem = shRowItem.getItemAt(nArrayIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (shRowItem != null && nArrayIndex == 0 && shRowItem.isExpandable()) {
                        if (shRowItem.isExpanded()) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    return new String();
                }
                case 1: {
                    if (phRowItem != null) {
                        phRowItem.setDisplayValue(phRowItem.getStepName());
                        return phRowItem;
                    }
                    return new String();
                }
                case 2: {
                    if (phRowItem != null) {
                        phRowItem.setDisplayValue(phRowItem.getOccurrence().toString());
                        return phRowItem;
                    }
                    return new String("?");
                }
                case 3: {
                    if (phRowItem != null) {
                        phRowItem.setDisplayValue(phRowItem.getParticipantName());
                        return phRowItem;
                    }
                    return new String();
                }
                case 4: {
                    if (phRowItem != null) {
                        phRowItem.setDisplayValue(phRowItem.getCompletionDate());
                        return phRowItem;
                    }
                    return new String();
                }
                case 5: {
                    if (phRowItem != null) {
                        phRowItem.setDisplayValue(phRowItem.getResponse());
                        return phRowItem;
                    }
                    return new String();
                }
                case 6: {
                    if (phRowItem != null) {
                        phRowItem.setDisplayValue(phRowItem.getComments());
                        return phRowItem;
                    }
                    return new String();
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                int[] nIndexes = new int[2];
                boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
                if (bFound) {
                    int nStepIndex = nIndexes[0];
                    int nArrayIndex = nIndexes[1];
                    VWStepHistoryRowItem rowItem = this.getRowItemAt(nStepIndex);
                    if (rowItem != null && nArrayIndex == 0 && rowItem.isExpandable()) {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return false;
    }

    public void setValueAt(Object value, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                int[] nIndexes = new int[2];
                boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
                if (!bFound) break;
                int nStepIndex = nIndexes[0];
                int nArrayIndex = nIndexes[1];
                VWStepHistoryRowItem rowItem = this.getRowItemAt(nStepIndex);
                if (rowItem == null || nArrayIndex != 0 || !rowItem.isExpandable() || value == null || !(value instanceof Boolean) || rowItem.isExpanded() == ((Boolean)value).booleanValue()) break;
                rowItem.setExpanded((Boolean)value);
                this.fireTableDataChanged();
                break;
            }
        }
    }

    private VWStepHistoryRowItem getRowItemAt(int nRowIndex) {
        VWStepHistoryRowItem rowItem = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            rowItem = (VWStepHistoryRowItem)this.m_rowData.elementAt(nRowIndex);
        }
        return rowItem;
    }

    public boolean tableToDataRow(int nRow, int[] nIndexes) {
        if (this.m_rowData == null) {
            return false;
        }
        boolean bFound = false;
        int nCount = 0;
        for (int i = 0; i < this.m_rowData.size(); ++i) {
            VWStepHistoryRowItem rowItem = this.getRowItemAt(i);
            int nRowCount = 0;
            if (rowItem != null) {
                nRowCount = rowItem.isExpanded() ? (nRowCount += rowItem.getRowCount()) : ++nRowCount;
            }
            if (nRow >= (nCount += nRowCount)) continue;
            bFound = true;
            nIndexes[0] = i;
            nIndexes[1] = nRow - nCount + nRowCount;
            break;
        }
        return bFound;
    }
}

